/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.RunToLineAdapter;
import org.eclipse.jdt.internal.debug.ui.actions.StepIntoSelectionHandler;
import org.eclipse.jdt.internal.debug.ui.actions.StepIntoSelectionUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class StepIntoSelectionActionDelegate
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private IEditorPart fEditorPart = null;
    private IWorkbenchWindow fWindow = null;
    private String fRunToLineType = null;
    private int fRunToLineLine = -1;
    private IDebugEventSetListener listener = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void run(IAction action) {
        IJavaStackFrame frame = this.getStackFrame();
        if (frame == null || !frame.isSuspended()) {
            return;
        }
        ITextSelection textSelection = this.getTextSelection();
        try {
            IMethod method = StepIntoSelectionUtils.getMethod(this.getTextSelection(), StepIntoSelectionUtils.getJavaElement(this.getActiveEditor().getEditorInput()));
            IType callingType = this.getType();
            if (method == null || callingType == null) {
                return;
            }
            int lineNumber = frame.getLineNumber();
            String callingTypeName = this.stripInnerNames(callingType.getFullyQualifiedName());
            String frameName = this.stripInnerNames(frame.getDeclaringTypeName());
            if (textSelection.getStartLine() != lineNumber - 1 || !callingTypeName.equals(frameName)) {
                this.runToLineBeforeStepIn(textSelection, frame.getThread(), method);
                return;
            }
            this.doStepIn(frame, method);
        }
        catch (DebugException e) {
            this.showErrorMessage(e.getStatus().getMessage());
            return;
        }
        catch (JavaModelException jme) {
            this.showErrorMessage(jme.getStatus().getMessage());
            return;
        }
    }

    private void doStepIn(IJavaStackFrame frame, IMethod method) throws DebugException {
        IStackFrame tos = frame.getThread().getTopStackFrame();
        if (tos == null) {
            return;
        }
        if (!tos.equals(frame)) {
            this.showErrorMessage(ActionMessages.StepIntoSelectionActionDelegate_Step_into_selection_only_available_in_top_stack_frame__3);
            return;
        }
        StepIntoSelectionHandler handler = new StepIntoSelectionHandler((IJavaThread)frame.getThread(), frame, method);
        handler.step();
    }

    private void runToLineBeforeStepIn(ITextSelection textSelection, final IThread thread, final IMethod method) {
        this.fRunToLineType = this.getType().getFullyQualifiedName();
        this.fRunToLineLine = textSelection.getStartLine() + 1;
        if (this.fRunToLineType == null || this.fRunToLineLine == -1) {
            return;
        }
        RunToLineAdapter runToLineAction = null;
        IEditorPart ed = this.getActiveEditor();
        if (ed != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runToLineAction = (IRunToLineTarget)ed.getAdapter((Class)clazz)) == null) {
                IAdapterManager adapterManager = Platform.getAdapterManager();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterManager.hasAdapter((Object)ed, clazz2.getName())) {
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    runToLineAction = (IRunToLineTarget)adapterManager.loadAdapter((Object)ed, clazz3.getName());
                }
            }
        }
        if (runToLineAction == null) {
            runToLineAction = new RunToLineAdapter();
        }
        this.listener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    switch (event.getKind()) {
                        case 2: {
                            this.handleSuspendEvent(event);
                            break;
                        }
                        case 8: {
                            this.handleTerminateEvent(event);
                            break;
                        }
                    }
                    ++i;
                }
            }

            private void handleSuspendEvent(DebugEvent event) {
                Object source = event.getSource();
                if (source instanceof IJavaThread) {
                    try {
                        IJavaStackFrame frame = (IJavaStackFrame)((IJavaThread)source).getTopStackFrame();
                        if (this.isExpectedFrame(frame)) {
                            DebugPlugin plugin = DebugPlugin.getDefault();
                            plugin.removeDebugEventListener(StepIntoSelectionActionDelegate.this.listener);
                            plugin.asyncExec(new Runnable(this, frame, method){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IJavaStackFrame val$frame;
                                private final /* synthetic */ IMethod val$method;
                                {
                                    this.this$1 = var1_1;
                                    this.val$frame = iJavaStackFrame;
                                    this.val$method = iMethod;
                                }

                                public void run() {
                                    try {
                                        StepIntoSelectionActionDelegate.access$1(1.access$0(this.this$1), this.val$frame, this.val$method);
                                    }
                                    catch (DebugException e) {
                                        1.access$0(this.this$1).showErrorMessage(e.getStatus().getMessage());
                                    }
                                }
                            });
                        }
                    }
                    catch (DebugException debugException) {
                        return;
                    }
                }
            }

            private boolean isExpectedFrame(IJavaStackFrame frame) throws DebugException {
                return frame != null && StepIntoSelectionActionDelegate.this.fRunToLineLine == frame.getLineNumber() && frame.getReceivingTypeName().equals(StepIntoSelectionActionDelegate.this.fRunToLineType);
            }

            private void handleTerminateEvent(DebugEvent event) {
                Object source = event.getSource();
                if (thread.getDebugTarget() == source) {
                    DebugPlugin.getDefault().removeDebugEventListener(StepIntoSelectionActionDelegate.this.listener);
                }
            }

            static /* synthetic */ StepIntoSelectionActionDelegate access$0(1 var0) {
                return var0.StepIntoSelectionActionDelegate.this;
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.listener);
        try {
            runToLineAction.runToLine((IWorkbenchPart)this.getActiveEditor(), (ISelection)textSelection, (ISuspendResume)thread);
        }
        catch (CoreException e) {
            DebugPlugin.getDefault().removeDebugEventListener(this.listener);
            this.showErrorMessage(ActionMessages.StepIntoSelectionActionDelegate_4);
            JDIDebugUIPlugin.log(e.getStatus());
        }
    }

    private ITextSelection getTextSelection() {
        IEditorPart part = this.getActiveEditor();
        if (part instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)part;
            return (ITextSelection)editor.getSelectionProvider().getSelection();
        }
        this.showErrorMessage(ActionMessages.StepIntoSelectionActionDelegate_Step_into_selection_only_available_in_Java_editor__4);
        return null;
    }

    protected IType getType() {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(this.getTextSelection());
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        return type;
    }

    protected void showErrorMessage(String message) {
        if (this.getActiveEditor() != null) {
            IEditorStatusLine statusLine;
            IEditorPart iEditorPart = this.getActiveEditor();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((statusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz)) != null) {
                statusLine.setMessage(true, message, null);
            }
        }
        JDIDebugUIPlugin.getStandardDisplay().beep();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditorPart = targetEditor;
    }

    protected IEditorPart getActiveEditor() {
        if (this.fWindow != null) {
            return this.fWindow.getActivePage().getActiveEditor();
        }
        return this.fEditorPart;
    }

    private String stripInnerNames(String fullyQualifiedName) {
        int index = fullyQualifiedName.indexOf(36);
        if (index > 0) {
            return fullyQualifiedName.substring(0, index);
        }
        return fullyQualifiedName;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IJavaStackFrame getStackFrame() {
        return EvaluationContextManager.getEvaluationContext((IWorkbenchPart)this.getActiveEditor());
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    static /* synthetic */ void access$1(StepIntoSelectionActionDelegate stepIntoSelectionActionDelegate, IJavaStackFrame iJavaStackFrame, IMethod iMethod) throws DebugException {
        stepIntoSelectionActionDelegate.doStepIn(iJavaStackFrame, iMethod);
    }
}

