/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.actions.ExpressionInputDialog;
import org.eclipse.jdt.internal.debug.ui.actions.StringValueInputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class JavaObjectValueEditor
implements IVariableValueEditor {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean editVariable(IVariable variable, Shell shell) {
        try {
            IJavaVariable javaVariable = (IJavaVariable)variable;
            String signature = javaVariable.getSignature();
            if ("Ljava/lang/String;".equals(signature)) {
                StringValueInputDialog dialog = new StringValueInputDialog(shell, javaVariable);
                if (dialog.open() == 0) {
                    String result = dialog.getResult();
                    if (dialog.isUseLiteralValue()) {
                        variable.setValue(result);
                    } else {
                        this.setValue(variable, result);
                    }
                }
            } else {
                ExpressionInputDialog dialog = new ExpressionInputDialog(shell, javaVariable);
                if (dialog.open() == 0) {
                    String result = dialog.getResult();
                    this.setValue(variable, result);
                }
            }
        }
        catch (DebugException e) {
            this.handleException(e);
        }
        return true;
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        block3: {
            IJavaVariable javaVariable = (IJavaVariable)variable;
            String signature = null;
            signature = javaVariable.getSignature();
            if (!"Ljava/lang/String;".equals(signature)) break block3;
            return false;
        }
        try {
            this.setValue(variable, expression);
        }
        catch (DebugException e) {
            this.handleException(e);
        }
        return true;
    }

    protected void setValue(final IVariable variable, final String expression) throws DebugException {
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IValue newValue = JavaObjectValueEditor.this.evaluate(expression);
                    if (newValue != null) {
                        variable.setValue(newValue);
                    }
                }
                catch (DebugException de) {
                    throw new InvocationTargetException(de);
                }
            }
        };
        try {
            service.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof DebugException) {
                throw (DebugException)e.getTargetException();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void handleException(DebugException e) {
        Throwable cause = e.getStatus().getException();
        if (cause instanceof InvalidTypeException) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 120, cause.getMessage(), null);
            JDIDebugUIPlugin.statusDialog(ActionMessages.JavaObjectValueEditor_3, (IStatus)status);
        } else {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue evaluate(String stringValue) throws DebugException {
        IJavaStackFrame frame;
        IAdaptable adaptable = DebugUITools.getDebugContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((frame = (IJavaStackFrame)adaptable.getAdapter((Class)clazz)) != null) {
            IJavaThread thread = (IJavaThread)frame.getThread();
            IJavaProject project = this.getProject(frame);
            if (project != null) {
                final IEvaluationResult[] results = new IEvaluationResult[1];
                IAstEvaluationEngine engine = JDIDebugPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)thread.getDebugTarget());
                IEvaluationListener listener = new IEvaluationListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void evaluationComplete(IEvaluationResult result) {
                        JavaObjectValueEditor javaObjectValueEditor = JavaObjectValueEditor.this;
                        synchronized (javaObjectValueEditor) {
                            results[0] = result;
                            JavaObjectValueEditor.this.notifyAll();
                        }
                    }
                };
                JavaObjectValueEditor javaObjectValueEditor = this;
                synchronized (javaObjectValueEditor) {
                    engine.evaluate(stringValue, frame, listener, 128, false);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                IEvaluationResult result = results[0];
                if (result == null) {
                    return null;
                }
                if (result.hasErrors()) {
                    DebugException exception = result.getException();
                    StringBuffer buffer = new StringBuffer();
                    if (exception == null) {
                        String[] messages = result.getErrorMessages();
                        int i = 0;
                        while (i < messages.length) {
                            buffer.append(messages[i]).append("\n ");
                            ++i;
                        }
                    } else {
                        buffer.append(EvaluateAction.getExceptionMessage(exception));
                    }
                    Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, buffer.toString(), null);
                    throw new DebugException((IStatus)status);
                }
                return result.getValue();
            }
        }
        return null;
    }

    protected String getExceptionMessage(Throwable exception) {
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            Throwable throwable = ce.getStatus().getException();
            if (throwable instanceof InvocationException) {
                return this.getInvocationExceptionMessage((InvocationException)throwable);
            }
            if (throwable instanceof CoreException) {
                return this.getExceptionMessage(throwable);
            }
            return ce.getStatus().getMessage();
        }
        String message = MessageFormat.format((String)ActionMessages.Evaluate_error_message_direct_exception, (Object[])new Object[]{exception.getClass()});
        if (exception.getMessage() != null) {
            message = MessageFormat.format((String)ActionMessages.Evaluate_error_message_exception_pattern, (Object[])new Object[]{message, exception.getMessage()});
        }
        return message;
    }

    protected String getInvocationExceptionMessage(InvocationException exception) {
        InvocationException ie = exception;
        ObjectReference ref = ie.exception();
        return MessageFormat.format((String)ActionMessages.Evaluate_error_message_wrapped_exception, (Object[])new Object[]{ref.referenceType().name()});
    }

    private IJavaProject getProject(IJavaStackFrame javaStackFrame) {
        ILaunch launch = javaStackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement((IStackFrame)javaStackFrame);
        if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)sourceElement;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sourceElement = iAdaptable.getAdapter((Class)clazz);
        }
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        return null;
    }
}

