/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.PotentialProgrammingProblemsFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class PotentialProgrammingProblemsCleanUp
extends AbstractCleanUp {
    public PotentialProgrammingProblemsCleanUp(Map options) {
        super(options);
    }

    public PotentialProgrammingProblemsCleanUp() {
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        boolean addSUID = this.isEnabled("cleanup.add_serial_version_id");
        if (!addSUID) {
            return false;
        }
        return this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_default_serial_version_id");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean addSUID = this.isEnabled("cleanup.add_serial_version_id");
        if (!addSUID) {
            return null;
        }
        return PotentialProgrammingProblemsFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_default_serial_version_id"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return PotentialProgrammingProblemsFix.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "warning");
        }
        return options;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id")) {
            result.add(MultiFixMessages.SerialVersionCleanUp_Generated_description);
        }
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_addDefaultSerialVersionId_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class E implements java.io.Serializable{\n");
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id")) {
            buf.append("    private static final long serialVersionUID = -391484377137870342L;\n");
        } else if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            buf.append("    private static final long serialVersionUID = 1L;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        IFix[] fix;
        return (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) && (fix = PotentialProgrammingProblemsFix.createMissingSerialVersionFixes(compilationUnit, problem)) != null;
    }

    public RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        super.checkPreConditions(project, compilationUnits, null);
        return PotentialProgrammingProblemsFix.checkPreConditions(project, compilationUnits, monitor, this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id"), this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id"), false);
    }

    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        return PotentialProgrammingProblemsFix.checkPostConditions(monitor);
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            return this.getNumberOfProblems(compilationUnit.getProblems(), 0x20000060);
        }
        return 0;
    }
}

