/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewPackageWizardPage
extends NewContainerWizardPage {
    private static final String PAGE_NAME = "NewPackageWizardPage";
    private static final String PACKAGE = "NewPackageWizardPage.package";
    private StringDialogField fPackageDialogField;
    private IStatus fPackageStatus;
    private IPackageFragment fCreatedPackageFragment;

    public NewPackageWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewPackageWizardPage_title);
        this.setDescription(NewWizardMessages.NewPackageWizardPage_description);
        this.fCreatedPackageFragment = null;
        PackageFieldAdapter adapter = new PackageFieldAdapter();
        this.fPackageDialogField = new StringDialogField();
        this.fPackageDialogField.setDialogFieldListener(adapter);
        this.fPackageDialogField.setLabelText(NewWizardMessages.NewPackageWizardPage_package_label);
        this.fPackageStatus = new StatusInfo();
    }

    public void init(IStructuredSelection selection) {
        IPackageFragment pf;
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        String pName = "";
        if (jelem != null && (pf = (IPackageFragment)jelem.getAncestor(4)) != null && !pf.isDefaultPackage()) {
            pName = pf.getElementName();
        }
        this.setPackageText(pName, true);
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus});
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(NewWizardMessages.NewPackageWizardPage_info);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_package_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fPackageDialogField.setFocus();
    }

    private void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns - 1);
        Text text = this.fPackageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace(composite);
        TextFieldNavigationHandler.install(text);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.packageChanged();
        }
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus});
    }

    private IStatus validatePackageName(String text) {
        IJavaProject project = this.getJavaProject();
        if (project == null || !project.exists()) {
            return JavaConventions.validatePackageName((String)text, (String)"1.3", (String)"1.3");
        }
        String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        String compliance = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validatePackageName((String)text, (String)sourceLevel, (String)compliance);
    }

    private IStatus packageChanged() {
        StatusInfo status = new StatusInfo();
        String packName = this.getPackageText();
        if (packName.length() > 0) {
            IStatus val = this.validatePackageName(packName);
            if (val.getSeverity() == 4) {
                status.setError(Messages.format(NewWizardMessages.NewPackageWizardPage_error_InvalidPackageName, val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(Messages.format(NewWizardMessages.NewPackageWizardPage_warning_DiscouragedPackageName, val.getMessage()));
            }
        } else {
            status.setError(NewWizardMessages.NewPackageWizardPage_error_EnterName);
            return status;
        }
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null && root.getJavaProject().exists()) {
            IPackageFragment pack = root.getPackageFragment(packName);
            try {
                IPath packagePath;
                IPath rootPath = root.getPath();
                IPath outputPath = root.getJavaProject().getOutputLocation();
                if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = pack.getPath())) {
                    status.setError(NewWizardMessages.NewPackageWizardPage_error_IsOutputFolder);
                    return status;
                }
                if (pack.exists()) {
                    if (pack.containsJavaResources() || !pack.hasSubpackages()) {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExists);
                    } else {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageNotShown);
                    }
                } else {
                    IFileStore store;
                    URI location = pack.getResource().getLocationURI();
                    if (location != null && (store = EFS.getStore((URI)location)).fetchInfo().exists()) {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExistsDifferentCase);
                    }
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return status;
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public void setPackageText(String str, boolean canBeModified) {
        this.fPackageDialogField.setText(str);
        this.fPackageDialogField.setEnabled(canBeModified);
    }

    public IResource getModifiedResource() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            return root.getPackageFragment(this.getPackageText()).getResource();
        }
        return null;
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    NewPackageWizardPage.this.createPackage(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public IPackageFragment getNewPackageFragment() {
        return this.fCreatedPackageFragment;
    }

    public void createPackage(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        String packName = this.getPackageText();
        this.fCreatedPackageFragment = root.createPackageFragment(packName, true, monitor);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private class PackageFieldAdapter
    implements IDialogFieldListener {
        private PackageFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewPackageWizardPage.this.fPackageStatus = NewPackageWizardPage.this.packageChanged();
            NewPackageWizardPage.this.handleFieldChanged(NewPackageWizardPage.PACKAGE);
        }
    }
}

