/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetConfigurationBlock;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class JavaProjectWizardFirstPage
extends WizardPage {
    private NameGroup fNameGroup;
    private LocationGroup fLocationGroup;
    private LayoutGroup fLayoutGroup;
    private JREGroup fJREGroup;
    private DetectGroup fDetectGroup;
    private Validator fValidator;
    private String fInitialName;
    private static final String PAGE_NAME = NewWizardMessages.JavaProjectWizardFirstPage_page_pageName;
    private WorkingSetGroup fWorkingSetGroup;
    private IWorkingSet[] fInitWorkingSets;

    public JavaProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.JavaProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.JavaProjectWizardFirstPage_page_description);
        this.fInitialName = "";
        this.initializeDefaultVM();
    }

    private void initializeDefaultVM() {
        JavaRuntime.getDefaultVMInstall();
    }

    public void setName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = new LocationGroup(composite);
        this.fJREGroup = new JREGroup(composite);
        this.fLayoutGroup = new LayoutGroup(composite);
        this.fWorkingSetGroup = new WorkingSetGroup(composite, this.fInitWorkingSets);
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fDetectGroup.addObserver(this.fJREGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
    }

    public IPath getLocationPath() {
        return this.fLocationGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        String location = this.fLocationGroup.getLocation().toOSString();
        IPath projectPath = Path.fromOSString((String)location);
        return Platform.getLocation().isPrefixOf(projectPath);
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrcBin() {
        return this.fLayoutGroup.isSrcBin();
    }

    public IPath getJREContainerPath() {
        return this.fJREGroup.getJREContainerPath();
    }

    public String getCompilerCompliance() {
        return this.fJREGroup.getSelectedCompilerCompliance();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.fInitWorkingSets = workingSets;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSetGroup.getSelectedWorkingSets();
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private final Link fHintText;
        private Label fIcon;
        private boolean fDetect;

        public DetectGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            this.fIcon = new Label(composite, 16384);
            this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            this.fIcon.setLayoutData((Object)gridData);
            this.fHintText = new Link(composite, 64);
            this.fHintText.setFont(composite.getFont());
            this.fHintText.addSelectionListener((SelectionListener)this);
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = JavaProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            gridData.heightHint = JavaProjectWizardFirstPage.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gridData);
            this.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
            if (JavaRuntime.getDefaultVMInstall() == null) {
                this.fHintText.setText(NewWizardMessages.JavaProjectWizardFirstPage_NoJREFound_link);
                this.fHintText.setVisible(true);
                this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.fIcon.setVisible(true);
                return;
            }
            String selectedCompliance = JavaProjectWizardFirstPage.this.fJREGroup.getSelectedCompilerCompliance();
            if (selectedCompliance != null) {
                String defaultCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                if (selectedCompliance.equals(defaultCompliance)) {
                    this.fHintText.setVisible(false);
                    this.fIcon.setVisible(false);
                } else {
                    this.fHintText.setText(Messages.format(NewWizardMessages.JavaProjectWizardFirstPage_DetectGroup_differendWorkspaceCC_message, new String[]{defaultCompliance, selectedCompliance}));
                    this.fHintText.setVisible(true);
                    this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                    this.fIcon.setVisible(true);
                }
                return;
            }
            selectedCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
            IVMInstall selectedJVM = JavaProjectWizardFirstPage.this.fJREGroup.getSelectedJVM();
            if (selectedJVM == null) {
                selectedJVM = JavaRuntime.getDefaultVMInstall();
            }
            String jvmCompliance = "1.4";
            if (selectedJVM instanceof IVMInstall2) {
                jvmCompliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)selectedJVM, "1.4");
            }
            if (!selectedCompliance.equals(jvmCompliance) && (JavaModelUtil.is50OrHigher(selectedCompliance) || JavaModelUtil.is50OrHigher(jvmCompliance))) {
                if (selectedCompliance.equals("1.5")) {
                    selectedCompliance = "5.0";
                } else if (selectedCompliance.equals("1.6")) {
                    selectedCompliance = "6.0";
                }
                this.fHintText.setText(Messages.format(NewWizardMessages.JavaProjectWizardFirstPage_DetectGroup_jre_message, new String[]{selectedCompliance, jvmCompliance}));
                this.fHintText.setVisible(true);
                this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.fIcon.setVisible(true);
            } else {
                this.fHintText.setVisible(false);
                this.fIcon.setVisible(false);
            }
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                if (JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                    this.fDetect = false;
                } else {
                    File directory = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toFile();
                    this.fDetect = directory.isDirectory();
                }
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.JavaProjectWizardFirstPage_DetectGroup_message);
                        this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                        this.fIcon.setVisible(true);
                    } else {
                        this.handlePossibleJVMChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            String id = "JRE".equals(e.text) ? jreID : complianceId;
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)id, (String[])new String[]{jreID, complianceId}, data).open();
            JavaProjectWizardFirstPage.this.fJREGroup.handlePossibleJVMChange();
            this.handlePossibleJVMChange();
        }
    }

    private final class JREGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private static final String LAST_SELECTED_EE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.execution.enviroment";
        private static final String LAST_SELECTED_JRE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.project.jre";
        private static final String LAST_SELECTED_JRE_KIND = "org.eclipse.jdt.ui.last.selected.jre.kind";
        private static final int DEFAULT_JRE = 0;
        private static final int PROJECT_JRE = 1;
        private static final int EE_JRE = 2;
        private final SelectionButtonDialogField fUseDefaultJRE;
        private final SelectionButtonDialogField fUseProjectJRE;
        private final SelectionButtonDialogField fUseEEJRE;
        private final ComboDialogField fJRECombo;
        private final ComboDialogField fEECombo;
        private final Group fGroup;
        private final Link fPreferenceLink;
        private IVMInstall[] fInstalledJVMs;
        private String[] fJRECompliance;
        private IExecutionEnvironment[] fInstalledEEs;
        private String[] fEECompliance;

        public JREGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_title);
            this.fUseDefaultJRE = new SelectionButtonDialogField(16);
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fUseDefaultJRE.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.fUseProjectJRE = new SelectionButtonDialogField(16);
            this.fUseProjectJRE.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_specific_compliance);
            this.fUseProjectJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fJRECombo = new ComboDialogField(8);
            this.fillInstalledJREs(this.fJRECombo);
            this.fJRECombo.setDialogFieldListener(this);
            Combo comboControl = this.fJRECombo.getComboControl((Composite)this.fGroup);
            comboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            comboControl.setVisibleItemCount(30);
            DialogField.createEmptySpace((Composite)this.fGroup);
            this.fUseEEJRE = new SelectionButtonDialogField(16);
            this.fUseEEJRE.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_specific_EE);
            this.fUseEEJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fEECombo = new ComboDialogField(8);
            this.fillExecutionEnvironments(this.fEECombo);
            this.fEECombo.setDialogFieldListener(this);
            Combo eeComboControl = this.fEECombo.getComboControl((Composite)this.fGroup);
            eeComboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            eeComboControl.setVisibleItemCount(30);
            DialogField.createEmptySpace((Composite)this.fGroup);
            switch (this.getLastSelectedJREKind()) {
                case 0: {
                    this.fUseDefaultJRE.setSelection(true);
                    break;
                }
                case 1: {
                    this.fUseProjectJRE.setSelection(true);
                    break;
                }
                case 2: {
                    this.fUseEEJRE.setSelection(true);
                }
            }
            this.fJRECombo.setEnabled(this.fUseProjectJRE.isSelected());
            this.fEECombo.setEnabled(this.fUseEEJRE.isSelected());
            this.fUseDefaultJRE.setDialogFieldListener(this);
            this.fUseProjectJRE.setDialogFieldListener(this);
            this.fUseEEJRE.setDialogFieldListener(this);
        }

        private void fillInstalledJREs(ComboDialogField comboField) {
            String selectedItem = this.getLastSelectedJRE();
            int selectionIndex = -1;
            if (this.fUseProjectJRE.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledJVMs = this.getWorkspaceJREs();
            Arrays.sort(this.fInstalledJVMs, new Comparator(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public int compare(Object arg0, Object arg1) {
                    IVMInstall i0 = (IVMInstall)arg0;
                    IVMInstall i1 = (IVMInstall)arg1;
                    if (i1 instanceof IVMInstall2 && i0 instanceof IVMInstall2) {
                        String cc0 = JavaModelUtil.getCompilerCompliance((IVMInstall2)i0, "1.4");
                        String cc1 = JavaModelUtil.getCompilerCompliance((IVMInstall2)i1, "1.4");
                        int result = cc1.compareTo(cc0);
                        if (result != 0) {
                            return result;
                        }
                    }
                    return Policy.getComparator().compare(i0.getName(), i1.getName());
                }
            });
            selectionIndex = -1;
            String[] jreLabels = new String[this.fInstalledJVMs.length];
            this.fJRECompliance = new String[this.fInstalledJVMs.length];
            int i = 0;
            while (i < this.fInstalledJVMs.length) {
                jreLabels[i] = this.fInstalledJVMs[i].getName();
                if (selectedItem != null && jreLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.fJRECompliance[i] = this.fInstalledJVMs[i] instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)this.fInstalledJVMs[i], "1.4") : "1.4";
                ++i;
            }
            comboField.setItems(jreLabels);
            if (selectionIndex == -1) {
                comboField.selectItem(this.getDefaultJVMName());
            } else {
                comboField.selectItem(selectedItem);
            }
        }

        private void fillExecutionEnvironments(ComboDialogField comboField) {
            String selectedItem = this.getLastSelectedEE();
            int selectionIndex = -1;
            if (this.fUseEEJRE.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            Arrays.sort(this.fInstalledEEs, new Comparator(this){
                final /* synthetic */ JREGroup this$1;
                {
                    this.this$1 = jREGroup;
                }

                public int compare(Object arg0, Object arg1) {
                    return Policy.getComparator().compare(((IExecutionEnvironment)arg0).getId(), ((IExecutionEnvironment)arg1).getId());
                }
            });
            selectionIndex = -1;
            String[] eeLabels = new String[this.fInstalledEEs.length];
            this.fEECompliance = new String[this.fInstalledEEs.length];
            int i = 0;
            while (i < this.fInstalledEEs.length) {
                eeLabels[i] = this.fInstalledEEs[i].getId();
                if (selectedItem != null && eeLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.fEECompliance[i] = JavaModelUtil.getExecutionEnvironmentCompliance(this.fInstalledEEs[i]);
                ++i;
            }
            comboField.setItems(eeLabels);
            if (selectionIndex == -1) {
                comboField.selectItem(this.getDefaultEEName());
            } else {
                comboField.selectItem(selectedItem);
            }
        }

        private IVMInstall[] getWorkspaceJREs() {
            ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    IVMInstall install = installs[j];
                    standins.add(new VMStandin(install));
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IVMInstall[standins.size()]);
        }

        private String getDefaultJVMName() {
            IVMInstall install = JavaRuntime.getDefaultVMInstall();
            if (install != null) {
                return install.getName();
            }
            return NewWizardMessages.JavaProjectWizardFirstPage_UnknownDefaultJRE_name;
        }

        private String getDefaultEEName() {
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            if (defaultVM != null) {
                int i = 0;
                while (i < environments.length) {
                    IVMInstall eeDefaultVM = environments[i].getDefaultVM();
                    if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                        return environments[i].getId();
                    }
                    ++i;
                }
            }
            String defaultCC = defaultVM instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)defaultVM, "1.4") : "1.4";
            int i = 0;
            while (i < environments.length) {
                String eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance(environments[i]);
                if (defaultCC.endsWith(eeCompliance)) {
                    return environments[i].getId();
                }
                ++i;
            }
            return "J2SE-1.5";
        }

        private String getDefaultJVMLabel() {
            return Messages.format(NewWizardMessages.JavaProjectWizardFirstPage_JREGroup_default_compliance, this.getDefaultJVMName());
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean detect = JavaProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fUseDefaultJRE.setEnabled(!detect);
            this.fUseProjectJRE.setEnabled(!detect);
            this.fUseEEJRE.setEnabled(!detect);
            this.fJRECombo.setEnabled(!detect && this.fUseProjectJRE.isSelected());
            this.fEECombo.setEnabled(!detect && this.fUseEEJRE.isSelected());
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)jreID, (String[])new String[]{jreID, complianceId}, data).open();
            this.handlePossibleJVMChange();
            JavaProjectWizardFirstPage.this.fDetectGroup.handlePossibleJVMChange();
        }

        public void handlePossibleJVMChange() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fillInstalledJREs(this.fJRECombo);
            this.fillExecutionEnvironments(this.fEECombo);
        }

        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
            JavaProjectWizardFirstPage.this.fDetectGroup.handlePossibleJVMChange();
            if (field == this.fJRECombo) {
                if (this.fUseProjectJRE.isSelected()) {
                    this.storeSelectionValue(this.fJRECombo, LAST_SELECTED_JRE_SETTINGS_KEY);
                }
            } else if (field == this.fEECombo) {
                if (this.fUseEEJRE.isSelected()) {
                    this.storeSelectionValue(this.fEECombo, LAST_SELECTED_EE_SETTINGS_KEY);
                }
            } else if (field == this.fUseDefaultJRE) {
                if (this.fUseDefaultJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 0);
                }
            } else if (field == this.fUseProjectJRE) {
                if (this.fUseProjectJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 1);
                }
            } else if (field == this.fUseEEJRE && this.fUseEEJRE.isSelected()) {
                JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 2);
            }
        }

        private void storeSelectionValue(ComboDialogField combo, String preferenceKey) {
            int index = combo.getSelectionIndex();
            if (index == -1) {
                return;
            }
            String item = combo.getItems()[index];
            JavaPlugin.getDefault().getDialogSettings().put(preferenceKey, item);
        }

        private int getLastSelectedJREKind() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            if (settings.get(LAST_SELECTED_JRE_KIND) == null) {
                return 0;
            }
            return settings.getInt(LAST_SELECTED_JRE_KIND);
        }

        private String getLastSelectedEE() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            return settings.get(LAST_SELECTED_EE_SETTINGS_KEY);
        }

        private String getLastSelectedJRE() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            return settings.get(LAST_SELECTED_JRE_SETTINGS_KEY);
        }

        public IVMInstall getSelectedJVM() {
            if (this.fUseProjectJRE.isSelected()) {
                int index = this.fJRECombo.getSelectionIndex();
                if (index >= 0 && index < this.fInstalledJVMs.length) {
                    return this.fInstalledJVMs[index];
                }
            } else {
                this.fUseEEJRE.isSelected();
            }
            return null;
        }

        public IPath getJREContainerPath() {
            int index;
            if (this.fUseProjectJRE.isSelected()) {
                int index2 = this.fJRECombo.getSelectionIndex();
                if (index2 >= 0 && index2 < this.fInstalledJVMs.length) {
                    return JavaRuntime.newJREContainerPath((IVMInstall)this.fInstalledJVMs[index2]);
                }
            } else if (this.fUseEEJRE.isSelected() && (index = this.fEECombo.getSelectionIndex()) >= 0 && index < this.fInstalledEEs.length) {
                return JavaRuntime.newJREContainerPath((IExecutionEnvironment)this.fInstalledEEs[index]);
            }
            return null;
        }

        public String getSelectedCompilerCompliance() {
            int index;
            if (this.fUseProjectJRE.isSelected()) {
                int index2 = this.fJRECombo.getSelectionIndex();
                if (index2 >= 0 && index2 < this.fJRECompliance.length) {
                    return this.fJRECompliance[index2];
                }
            } else if (this.fUseEEJRE.isSelected() && (index = this.fEECombo.getSelectionIndex()) >= 0 && index < this.fEECompliance.length) {
                return this.fEECompliance[index];
            }
            return null;
        }
    }

    private final class LayoutGroup
    implements Observer,
    SelectionListener {
        private final SelectionButtonDialogField fStdRadio;
        private final SelectionButtonDialogField fSrcBinRadio;
        private final Group fGroup;
        private final Link fPreferenceLink;

        public LayoutGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_title);
            this.fStdRadio = new SelectionButtonDialogField(16);
            this.fStdRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_option_oneFolder);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_option_separateFolders);
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
        }

        public void update(Observable o, Object arg) {
            boolean detect = JavaProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!detect);
            this.fSrcBinRadio.setEnabled(!detect);
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String id = "org.eclipse.jdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
            JavaProjectWizardFirstPage.this.fDetectGroup.handlePossibleJVMChange();
            JavaProjectWizardFirstPage.this.fJREGroup.handlePossibleJVMChange();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

        public LocationGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_title);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fExternalRadio.attachDialogField(this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(JavaProjectWizardFirstPage.this.getShell());
            dialog.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_directory_message);
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLocation.setText(selectedDirectory);
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(JavaProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IWorkspace workspace = JavaPlugin.getWorkspace();
            String name = JavaProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_enterProjectName);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = JavaProjectWizardFirstPage.this.getProjectHandle();
            if (handle.exists()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_projectAlreadyExists);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_enterLocation);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_invalidDirectory);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                if (!this.canCreate(projectPath.toFile())) {
                    JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_cannotCreateAtExternalLocation);
                    JavaProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
                if (!Platform.getLocation().equals((Object)projectPath) && Platform.getLocation().isPrefixOf(projectPath)) {
                    if (!Platform.getLocation().equals((Object)projectPath.removeLastSegments(1))) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_notOnWorkspaceRoot);
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                    if (!projectPath.toFile().exists()) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_notExisingProjectOnWorkspaceRoot);
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                    String existingName = projectPath.lastSegment();
                    if (!existingName.equals(JavaProjectWizardFirstPage.this.fNameGroup.getName())) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(Messages.format(NewWizardMessages.JavaProjectWizardFirstPage_Message_invalidProjectNameForWorkspaceRoot, existingName));
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                } else {
                    IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
                    if (!locationStatus.isOK()) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                }
            } else {
                IPath projectFolder = projectPath.append(JavaProjectWizardFirstPage.this.fNameGroup.getName());
                if (projectFolder.toFile().exists()) {
                    JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_existingFolderInWorkspace);
                    JavaProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
            }
            JavaProjectWizardFirstPage.this.setPageComplete(true);
            JavaProjectWizardFirstPage.this.setErrorMessage(null);
            JavaProjectWizardFirstPage.this.setMessage(null);
        }

        private boolean canCreate(File file) {
            while (!file.exists()) {
                if ((file = file.getParentFile()) != null) continue;
                return false;
            }
            return file.canWrite();
        }
    }

    private final class WorkingSetGroup {
        private WorkingSetConfigurationBlock fWorkingSetBlock;

        public WorkingSetGroup(Composite composite, IWorkingSet[] initialWorkingSets) {
            Group workingSetGroup = new Group(composite, 0);
            workingSetGroup.setFont(composite.getFont());
            workingSetGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_WorkingSets_group);
            workingSetGroup.setLayoutData((Object)new GridData(4, 128, true, false));
            workingSetGroup.setLayout((Layout)new GridLayout(1, false));
            String[] workingSetIds = new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
            this.fWorkingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, NewWizardMessages.JavaProjectWizardFirstPage_EnableWorkingSet_button, JavaPlugin.getDefault().getDialogSettings());
            this.fWorkingSetBlock.setDialogMessage(NewWizardMessages.JavaProjectWizardFirstPage_WorkingSetSelection_message);
            this.fWorkingSetBlock.setSelection(initialWorkingSets);
            this.fWorkingSetBlock.createContent((Composite)workingSetGroup);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
    }
}

