/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ColoredString {
    public static final Style DEFAULT_STYLE = null;
    private StringBuffer fBuffer = new StringBuffer();
    private ArrayList fRanges = null;

    public ColoredString() {
    }

    public ColoredString(String text) {
        this(text, DEFAULT_STYLE);
    }

    public ColoredString(String text, Style style) {
        this();
        this.append(text, style);
    }

    public String getString() {
        return this.fBuffer.toString();
    }

    public int length() {
        return this.fBuffer.length();
    }

    public Iterator getRanges() {
        if (!this.hasRanges()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.getRangesList().iterator();
    }

    public ColoredString append(String text) {
        return this.append(text, DEFAULT_STYLE);
    }

    public ColoredString append(char ch) {
        return this.append(String.valueOf(ch), DEFAULT_STYLE);
    }

    public ColoredString append(ColoredString string) {
        int offset = this.fBuffer.length();
        this.fBuffer.append(string.getString());
        Iterator iterator = string.getRanges();
        while (iterator.hasNext()) {
            StyleRange curr = (StyleRange)iterator.next();
            this.addRange(new StyleRange(offset + curr.offset, curr.length, curr.style));
        }
        return this;
    }

    public ColoredString append(String text, Style style) {
        if (text.length() == 0) {
            return this;
        }
        int offset = this.fBuffer.length();
        this.fBuffer.append(text);
        if (style != null) {
            int nRanges = this.getNumberOfRanges();
            if (nRanges > 0) {
                StyleRange last = this.getRange(nRanges - 1);
                if (last.offset + last.length == offset && style.equals(last.style)) {
                    last.length += text.length();
                    return this;
                }
            }
            this.addRange(new StyleRange(offset, text.length(), style));
        }
        return this;
    }

    public void colorize(int offset, int length, Style style) {
        if (offset < 0 || offset + length > this.fBuffer.length()) {
            throw new IllegalArgumentException("Invalid offset (" + offset + ") or length (" + length + ")");
        }
        int insertPos = 0;
        int nRanges = this.getNumberOfRanges();
        int i = 0;
        while (i < nRanges) {
            StyleRange curr = this.getRange(i);
            if (curr.offset + curr.length <= offset) {
                insertPos = i + 1;
            }
            ++i;
        }
        if (insertPos < nRanges) {
            StyleRange curr = this.getRange(insertPos);
            if (curr.offset > offset + length) {
                throw new IllegalArgumentException("Overlapping ranges");
            }
        }
        this.addRange(insertPos, new StyleRange(offset, length, style));
    }

    public String toString() {
        return this.fBuffer.toString();
    }

    private boolean hasRanges() {
        return this.fRanges != null && !this.fRanges.isEmpty();
    }

    private int getNumberOfRanges() {
        return this.fRanges == null ? 0 : this.fRanges.size();
    }

    private StyleRange getRange(int index) {
        if (this.fRanges != null) {
            return (StyleRange)this.fRanges.get(index);
        }
        throw new IndexOutOfBoundsException();
    }

    private void addRange(StyleRange range) {
        this.getRangesList().add(range);
    }

    private void addRange(int index, StyleRange range) {
        this.getRangesList().add(index, range);
    }

    private List getRangesList() {
        if (this.fRanges == null) {
            this.fRanges = new ArrayList(2);
        }
        return this.fRanges;
    }

    public static class Style {
        private final String fForegroundColorName;

        public Style(String foregroundColorName) {
            this.fForegroundColorName = foregroundColorName;
        }

        public String getForegroundColorName() {
            return this.fForegroundColorName;
        }
    }

    public static class StyleRange {
        public int offset;
        public int length;
        public Style style;

        public StyleRange(int offset, int length, Style style) {
            this.offset = offset;
            this.length = length;
            this.style = style;
        }
    }
}

