/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckIterator;
import org.eclipse.jdt.internal.ui.text.spelling.SpellingEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;

public class TextSpellingEngine
extends SpellingEngine {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void check(IDocument document, IRegion[] regions, ISpellChecker checker, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        SpellingEngine.SpellEventListener listener = new SpellingEngine.SpellEventListener(collector, document);
        try {
            checker.addListener(listener);
            int i = 0;
            while (i < regions.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                if (listener.isProblemsThresholdReached()) {
                    return;
                }
                checker.execute(new SpellCheckIterator(document, regions[i], checker.getLocale()));
                ++i;
            }
            return;
        }
        finally {
            checker.removeListener(listener);
        }
    }
}

