/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Composite;

public class CleanUpPreview
extends JavaPreview {
    private ICleanUp[] fPreviewCleanUps;
    private boolean fFormat;

    public CleanUpPreview(Composite parent, ICleanUp[] cleanUps) {
        super(JavaCore.getDefaultOptions(), parent);
        this.fPreviewCleanUps = cleanUps;
        this.fFormat = false;
    }

    public void setCleanUps(ICleanUp[] fCleanUps) {
        this.fPreviewCleanUps = fCleanUps;
    }

    public void setFormat(boolean enable) {
        this.fFormat = enable;
    }

    protected void doFormatPreview() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fPreviewCleanUps.length) {
            buf.append(this.fPreviewCleanUps[i].getPreview());
            buf.append("\n");
            ++i;
        }
        this.format(buf.toString());
    }

    private void format(String text) {
        block8: {
            if (text == null) {
                this.fPreviewDocument.set("");
                return;
            }
            this.fPreviewDocument.set(text);
            if (!this.fFormat) {
                return;
            }
            this.fSourceViewer.setRedraw(false);
            CommentFormattingContext context = new CommentFormattingContext();
            try {
                try {
                    IContentFormatter formatter = this.fViewerConfiguration.getContentFormatter((ISourceViewer)this.fSourceViewer);
                    if (formatter instanceof IContentFormatterExtension) {
                        IContentFormatterExtension extension = (IContentFormatterExtension)formatter;
                        context.setProperty("formatting.context.preferences", JavaCore.getOptions());
                        context.setProperty("formatting.context.document", true);
                        extension.format((IDocument)this.fPreviewDocument, (IFormattingContext)context);
                        break block8;
                    }
                    formatter.format((IDocument)this.fPreviewDocument, (IRegion)new Region(0, this.fPreviewDocument.getLength()));
                }
                catch (Exception e) {
                    Status status = new Status(4, JavaPlugin.getPluginId(), 10001, MultiFixMessages.CleanUpRefactoringWizard_formatterException_errorMessage, (Throwable)e);
                    JavaPlugin.log((IStatus)status);
                    context.dispose();
                    this.fSourceViewer.setRedraw(true);
                }
            }
            finally {
                context.dispose();
                this.fSourceViewer.setRedraw(true);
            }
        }
    }

    public void setWorkingValues(Map workingValues) {
    }
}

