/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

class ParameterData {
    public static final String PROPERTY;
    private SingleVariableDeclaration fDeclaration;
    private int fAccessMode;
    private List fReferences;
    private int fOperatorPrecedence;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.code.ParameterData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PROPERTY = clazz.getName();
    }

    public ParameterData(SingleVariableDeclaration decl) {
        this.fDeclaration = decl;
        this.fAccessMode = 1;
        this.fReferences = new ArrayList(2);
        this.fOperatorPrecedence = -1;
    }

    public String getName() {
        return this.fDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getTypeBinding() {
        return this.fDeclaration.resolveBinding().getType();
    }

    public void addReference(ASTNode node) {
        this.fReferences.add(node);
    }

    public List references() {
        return this.fReferences;
    }

    public void setAccessMode(int mode) {
        this.fAccessMode = mode;
    }

    public boolean isUnused() {
        return this.fAccessMode == 1;
    }

    public boolean isReadOnly() {
        return (this.fAccessMode & 6) != 0;
    }

    public boolean isWrite() {
        return (this.fAccessMode & 0x38) != 0;
    }

    public int getSimplifiedAccessMode() {
        if (this.isWrite()) {
            return 8;
        }
        if (this.isReadOnly()) {
            return 2;
        }
        return 1;
    }

    public int getNumberOfAccesses() {
        return this.fReferences.size();
    }

    public boolean needsEvaluation() {
        return this.fReferences.size() > 1;
    }

    public void setOperatorPrecedence(ASTNode node, int precedence) {
        this.setOperatorPrecedence(precedence);
    }

    private void setOperatorPrecedence(int newValue) {
        this.fOperatorPrecedence = newValue == -1 ? newValue : (this.fOperatorPrecedence == -1 ? newValue : Math.min(this.fOperatorPrecedence, newValue));
    }

    public int getOperatorPrecedence() {
        return this.fOperatorPrecedence;
    }
}

