/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

abstract class PackageReorgChange
extends JDTChange {
    private String fPackageHandle;
    private String fDestinationHandle;
    private INewNameQuery fNameQuery;
    static /* synthetic */ Class class$0;

    PackageReorgChange(IPackageFragment pack, IPackageFragmentRoot dest, INewNameQuery nameQuery) {
        this.fPackageHandle = pack.getHandleIdentifier();
        this.fDestinationHandle = dest.getHandleIdentifier();
        this.fNameQuery = nameQuery;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws JavaModelException, OperationCanceledException;

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 0);
    }

    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(this.getName(), 1);
        try {
            IPackageFragment pack = this.getPackage();
            ResourceMapping mapping = JavaElementResourceMapping.create(pack);
            Change result = this.doPerformReorg(pm);
            this.markAsExecuted(pack, mapping);
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    public Object getModifiedElement() {
        return this.getPackage();
    }

    IPackageFragmentRoot getDestination() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fDestinationHandle);
    }

    IPackageFragment getPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fPackageHandle);
    }

    String getNewName() throws OperationCanceledException {
        if (this.fNameQuery == null) {
            return null;
        }
        return this.fNameQuery.getNewName();
    }

    private void markAsExecuted(IPackageFragment pack, ResourceMapping mapping) {
        ReorgExecutionLog log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            log.markAsProcessed((Object)pack);
            log.markAsProcessed((Object)mapping);
        }
    }
}

