/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.CodeFormatCleanUp;
import org.eclipse.jdt.internal.ui.fix.CodeStyleCleanUp;
import org.eclipse.jdt.internal.ui.fix.CommentFormatCleanUp;
import org.eclipse.jdt.internal.ui.fix.ControlStatementsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ConvertLoopCleanUp;
import org.eclipse.jdt.internal.ui.fix.ExpressionsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.ImportsCleanUp;
import org.eclipse.jdt.internal.ui.fix.Java50CleanUp;
import org.eclipse.jdt.internal.ui.fix.PotentialProgrammingProblemsCleanUp;
import org.eclipse.jdt.internal.ui.fix.SortMembersCleanUp;
import org.eclipse.jdt.internal.ui.fix.StringCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnnecessaryCodeCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.fix.VariableDeclarationCleanUp;
import org.eclipse.jdt.internal.ui.refactoring.IScheduledRefactoring;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.text.edits.UndoEdit;

public class CleanUpRefactoring
extends Refactoring
implements IScheduledRefactoring {
    private static final RefactoringTickProvider CLEAN_UP_REFACTORING_TICK_PROVIDER = new RefactoringTickProvider(0, 1, 0, 0);
    private final List fCleanUps;
    private final Hashtable fProjects;
    private Change fChange;
    private boolean fLeaveFilesDirty;
    private final String fName;

    public CleanUpRefactoring() {
        this(FixMessages.CleanUpRefactoring_Refactoring_name);
    }

    public CleanUpRefactoring(String name) {
        this.fName = name;
        this.fCleanUps = new ArrayList();
        this.fProjects = new Hashtable();
    }

    public void addCompilationUnit(ICompilationUnit unit) {
        IJavaProject javaProject = unit.getJavaProject();
        if (!this.fProjects.containsKey(javaProject)) {
            this.fProjects.put(javaProject, new ArrayList());
        }
        List cus = (List)this.fProjects.get(javaProject);
        cus.add(unit);
    }

    public void clearCompilationUnits() {
        this.fProjects.clear();
    }

    public boolean hasCompilationUnits() {
        return !this.fProjects.isEmpty();
    }

    public ICompilationUnit[] getCompilationUnits() {
        ArrayList cus = new ArrayList();
        Iterator iter = this.fProjects.values().iterator();
        while (iter.hasNext()) {
            List pcus = (List)iter.next();
            cus.addAll(pcus);
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    public void addCleanUp(ICleanUp fix) {
        this.fCleanUps.add(fix);
    }

    public void clearCleanUps() {
        this.fCleanUps.clear();
    }

    public boolean hasCleanUps() {
        return !this.fCleanUps.isEmpty();
    }

    public ICleanUp[] getCleanUps() {
        return this.fCleanUps.toArray(new ICleanUp[this.fCleanUps.size()]);
    }

    public IJavaProject[] getProjects() {
        return this.fProjects.keySet().toArray(new IJavaProject[this.fProjects.keySet().size()]);
    }

    public void setLeaveFilesDirty(boolean leaveFilesDirty) {
        this.fLeaveFilesDirty = leaveFilesDirty;
    }

    public String getName() {
        return this.fName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm != null) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm != null) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
        return this.fChange;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if (this.fProjects.size() == 0 || this.fCleanUps.size() == 0) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
            this.fChange = new NullChange();
            return new RefactoringStatus();
        }
        int cuCount = 0;
        Iterator iter = this.fProjects.keySet().iterator();
        while (iter.hasNext()) {
            IJavaProject project = (IJavaProject)iter.next();
            cuCount += ((List)this.fProjects.get(project)).size();
        }
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", cuCount * 2 * this.fCleanUps.size() + 4 * this.fCleanUps.size());
        try {
            DynamicValidationStateChange change = new DynamicValidationStateChange(this.getName());
            change.setSchedulingRule(this.getSchedulingRule());
            Iterator projectIter = this.fProjects.keySet().iterator();
            while (projectIter.hasNext()) {
                IJavaProject project = (IJavaProject)projectIter.next();
                List compilationUnits = (List)this.fProjects.get(project);
                ICompilationUnit[] cus = compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]);
                ICleanUp[] cleanUps = this.fCleanUps.toArray(new ICleanUp[this.fCleanUps.size()]);
                result.merge(this.initialize(project));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                result.merge(this.checkPreConditions(project, cus, (IProgressMonitor)new SubProgressMonitor(pm, 3 * cleanUps.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                Change[] changes = this.cleanUpProject(project, cus, cleanUps, pm);
                result.merge(this.checkPostConditions(new SubProgressMonitor(pm, cleanUps.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                int i = 0;
                while (i < changes.length) {
                    change.add(changes[i]);
                    ++i;
                }
            }
            this.fChange = change;
            ArrayList files = new ArrayList();
            this.findFilesToBeModified(change, files);
            result.merge(Checks.validateModifiesFiles(files.toArray(new IFile[files.size()]), this.getValidationContext()));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
        }
        finally {
            pm.done();
        }
        return result;
    }

    private void findFilesToBeModified(CompositeChange change, List result) throws JavaModelException {
        Change[] children = change.getChildren();
        int i = 0;
        while (i < children.length) {
            Change child = children[i];
            if (child instanceof CompositeChange) {
                this.findFilesToBeModified((CompositeChange)child, result);
            } else if (child instanceof MultiStateCompilationUnitChange) {
                result.add(((MultiStateCompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
            } else if (child instanceof CompilationUnitChange) {
                result.add(((CompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
            }
            ++i;
        }
    }

    private Change[] cleanUpProject(IJavaProject project, ICompilationUnit[] compilationUnits, ICleanUp[] cleanUps, IProgressMonitor monitor) throws CoreException {
        CleanUpFixpointIterator iter = new CleanUpFixpointIterator(project, compilationUnits, cleanUps);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 2 * compilationUnits.length * cleanUps.length);
        subMonitor.beginTask("", compilationUnits.length);
        subMonitor.subTask(Messages.format(FixMessages.CleanUpRefactoring_Parser_Startup_message, project.getElementName()));
        try {
            while (iter.hasNext()) {
                iter.next((IProgressMonitor)subMonitor);
            }
            Change[] changeArray = iter.getResult();
            return changeArray;
        }
        finally {
            iter.dispose();
            subMonitor.done();
        }
    }

    private RefactoringStatus initialize(IJavaProject javaProject) throws CoreException {
        Map options = CleanUpPreferenceUtil.loadOptions((IScopeContext)new ProjectScope(javaProject.getProject()));
        if (options == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(FixMessages.CleanUpRefactoring_could_not_retrive_profile, javaProject.getElementName()));
        }
        ICleanUp[] cleanUps = this.getCleanUps();
        int j = 0;
        while (j < cleanUps.length) {
            cleanUps[j].initialize(options);
            ++j;
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkPreConditions(IJavaProject javaProject, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ICleanUp[] cleanUps = this.getCleanUps();
        monitor.beginTask("", compilationUnits.length * cleanUps.length);
        monitor.subTask(Messages.format(FixMessages.CleanUpRefactoring_Initialize_message, javaProject.getElementName()));
        try {
            int j = 0;
            while (j < cleanUps.length) {
                result.merge(cleanUps[j].checkPreConditions(javaProject, compilationUnits, (IProgressMonitor)new SubProgressMonitor(monitor, compilationUnits.length)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                ++j;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private RefactoringStatus checkPostConditions(SubProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ICleanUp[] cleanUps = this.getCleanUps();
        monitor.beginTask("", cleanUps.length);
        monitor.subTask(FixMessages.CleanUpRefactoring_checkingPostConditions_message);
        try {
            int j = 0;
            while (j < cleanUps.length) {
                result.merge(cleanUps[j].checkPostConditions((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                ++j;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static String getChangeName(ICompilationUnit compilationUnit) {
        StringBuffer buf = new StringBuffer();
        JavaElementLabels.getCompilationUnitLabel(compilationUnit, JavaElementLabels.ALL_DEFAULT, buf);
        buf.append(JavaElementLabels.CONCAT_STRING);
        StringBuffer buf2 = new StringBuffer();
        JavaElementLabels.getPackageFragmentLabel((IPackageFragment)compilationUnit.getParent(), 0x800000000L, buf2);
        buf.append(buf2.toString().replace('.', '/'));
        return buf.toString();
    }

    public static CleanUpChange calculateChange(CompilationUnit ast, ICompilationUnit source, ICleanUp[] cleanUps, List undoneCleanUps) throws CoreException {
        if (cleanUps.length == 0) {
            return null;
        }
        CleanUpChange solution = null;
        int i = 0;
        do {
            ICleanUp cleanUp = cleanUps[i];
            IFix fix = ast == null || !cleanUp.requireAST(source) ? cleanUp.createFix(source) : cleanUp.createFix(ast);
            if (fix == null) continue;
            TextChange current = fix.createChange();
            TextEdit currentEdit = CleanUpRefactoring.pack(current.getEdit());
            if (solution != null) {
                if (CleanUpRefactoring.intersects(currentEdit, solution.getEdit())) {
                    undoneCleanUps.add(cleanUp);
                    continue;
                }
                CleanUpChange merge = new CleanUpChange(FixMessages.CleanUpRefactoring_clean_up_multi_chang_name, source);
                merge.setEdit(CleanUpRefactoring.merge(currentEdit, solution.getEdit()));
                CleanUpRefactoring.copyChangeGroups(merge, (TextChange)solution);
                CleanUpRefactoring.copyChangeGroups(merge, current);
                solution = merge;
                continue;
            }
            solution = new CleanUpChange(current.getName(), source);
            solution.setEdit(currentEdit);
            CleanUpRefactoring.copyChangeGroups(solution, current);
        } while (++i < cleanUps.length && (solution == null || ast != null && !cleanUps[i].needsFreshAST(ast)));
        while (i < cleanUps.length) {
            undoneCleanUps.add(cleanUps[i]);
            ++i;
        }
        return solution;
    }

    private static void copyChangeGroups(CompilationUnitChange target, TextChange source) {
        TextEditBasedChangeGroup[] changeGroups = source.getChangeGroups();
        int i = 0;
        while (i < changeGroups.length) {
            TextEditGroup newGroup;
            TextEditGroup textEditGroup = changeGroups[i].getTextEditGroup();
            if (textEditGroup instanceof CategorizedTextEditGroup) {
                String label = textEditGroup.getName();
                newGroup = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
            } else {
                newGroup = new TextEditGroup(textEditGroup.getName());
            }
            TextEdit[] textEdits = textEditGroup.getTextEdits();
            int j = 0;
            while (j < textEdits.length) {
                newGroup.addTextEdit(textEdits[j]);
                ++j;
            }
            target.addTextEditGroup(newGroup);
            ++i;
        }
    }

    private static TextEdit pack(TextEdit edit) {
        final ArrayList edits = new ArrayList();
        edit.accept(new TextEditVisitor(){

            public boolean visitNode(TextEdit node) {
                if (node instanceof MultiTextEdit) {
                    return true;
                }
                edits.add(node);
                return false;
            }
        });
        MultiTextEdit result = new MultiTextEdit();
        Iterator iterator = edits.iterator();
        while (iterator.hasNext()) {
            TextEdit child = (TextEdit)iterator.next();
            child.getParent().removeChild(child);
            TextChangeCompatibility.insert((TextEdit)result, child);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean intersects(TextEdit edit1, TextEdit edit2) {
        block13: {
            if (!(edit1 instanceof MultiTextEdit) || !(edit2 instanceof MultiTextEdit)) break block13;
            multiTextEdit1 = (MultiTextEdit)edit1;
            children1 = multiTextEdit1.getChildren();
            multiTextEdit2 = (MultiTextEdit)edit2;
            children2 = multiTextEdit2.getChildren();
            i1 = 0;
            i2 = 0;
            ** GOTO lbl22
            {
                if (++i1 >= children1.length) {
                    return false;
                }
                do {
                    if (children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue block0;
                    while (children2[i2].getExclusiveEnd() < children1[i1].getOffset()) {
                        if (++i2 < children2.length) continue;
                        return false;
                    }
                    if (CleanUpRefactoring.intersects(children1[i1], children2[i2])) {
                        return true;
                    }
                    if (children1[i1].getExclusiveEnd() < children2[i2].getExclusiveEnd()) {
                        ++i1;
                        continue;
                    }
                    ++i2;
lbl22:
                    // 3 sources

                } while (i1 < children1.length && i2 < children2.length);
            }
            return false;
        }
        if (edit1 instanceof MultiTextEdit) {
            multiTextEdit1 = (MultiTextEdit)edit1;
            children = multiTextEdit1.getChildren();
            i = 0;
            while (i < children.length) {
                child = children[i];
                if (CleanUpRefactoring.intersects(child, edit2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (edit2 instanceof MultiTextEdit) {
            multiTextEdit2 = (MultiTextEdit)edit2;
            children = multiTextEdit2.getChildren();
            i = 0;
            while (i < children.length) {
                child = children[i];
                if (CleanUpRefactoring.intersects(child, edit1)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        start1 = edit1.getOffset();
        end1 = start1 + edit1.getLength();
        start2 = edit2.getOffset();
        end2 = start2 + edit2.getLength();
        if (start1 > end2) {
            return false;
        }
        return start2 <= end1;
    }

    /*
     * Unable to fully structure code
     */
    private static TextEdit merge(TextEdit edit1, TextEdit edit2) {
        block16: {
            result = new MultiTextEdit();
            if (!(edit1 instanceof MultiTextEdit) || !(edit2 instanceof MultiTextEdit)) break block16;
            multiTextEdit1 = (MultiTextEdit)edit1;
            children1 = multiTextEdit1.getChildren();
            if (children1.length == 0) {
                return edit2;
            }
            multiTextEdit2 = (MultiTextEdit)edit2;
            children2 = multiTextEdit2.getChildren();
            if (children2.length == 0) {
                return edit1;
            }
            i1 = 0;
            i2 = 0;
            ** GOTO lbl51
            {
                edit1.removeChild(0);
                result.addChild(children1[i1]);
                ++i1;
                do {
                    if (i1 < children1.length && children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue block0;
                    if (i1 < children1.length) ** GOTO lbl33
                    i = i2;
                    while (i < children2.length) {
                        edit2.removeChild(0);
                        result.addChild(children2[i]);
                        ++i;
                    }
                    return result;
lbl-1000:
                    // 1 sources

                    {
                        edit2.removeChild(0);
                        result.addChild(children2[i2]);
                        ++i2;
lbl33:
                        // 2 sources

                        ** while (i2 < children2.length && children2[i2].getExclusiveEnd() < children1[i1].getOffset())
                    }
lbl34:
                    // 1 sources

                    if (i2 >= children2.length) {
                        i = i1;
                        while (i < children1.length) {
                            edit1.removeChild(0);
                            result.addChild(children1[i]);
                            ++i;
                        }
                        return result;
                    }
                    if (children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue;
                    edit1.removeChild(0);
                    edit2.removeChild(0);
                    result.addChild(CleanUpRefactoring.merge(children1[i1], children2[i2]));
                    ++i1;
                    ++i2;
lbl51:
                    // 3 sources

                } while (i1 < children1.length && i2 < children2.length);
            }
            return result;
        }
        if (edit1 instanceof MultiTextEdit) {
            children = edit1.getChildren();
            i = 0;
            while (children[i].getExclusiveEnd() < edit2.getOffset()) {
                edit1.removeChild(0);
                result.addChild(children[i]);
                if (++i < children.length) continue;
                result.addChild(edit2);
                return result;
            }
            edit1.removeChild(0);
            result.addChild(CleanUpRefactoring.merge(children[i], edit2));
            ++i;
            while (i < children.length) {
                edit1.removeChild(0);
                result.addChild(children[i]);
                ++i;
            }
            return result;
        }
        if (edit2 instanceof MultiTextEdit) {
            children = edit2.getChildren();
            i = 0;
            while (children[i].getExclusiveEnd() < edit1.getOffset()) {
                edit2.removeChild(0);
                result.addChild(children[i]);
                if (++i < children.length) continue;
                result.addChild(edit1);
                return result;
            }
            edit2.removeChild(0);
            result.addChild(CleanUpRefactoring.merge(edit1, children[i]));
            ++i;
            while (i < children.length) {
                edit2.removeChild(0);
                result.addChild(children[i]);
                ++i;
            }
            return result;
        }
        if (edit1.getExclusiveEnd() < edit2.getOffset()) {
            result.addChild(edit1);
            result.addChild(edit2);
        } else {
            result.addChild(edit2);
            result.addChild(edit1);
        }
        return result;
    }

    protected RefactoringTickProvider doGetRefactoringTickProvider() {
        return CLEAN_UP_REFACTORING_TICK_PROVIDER;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static ICleanUp[] createCleanUps() {
        return new ICleanUp[]{new CodeStyleCleanUp(), new ControlStatementsCleanUp(), new ConvertLoopCleanUp(), new VariableDeclarationCleanUp(), new ExpressionsCleanUp(), new UnusedCodeCleanUp(), new Java50CleanUp(), new PotentialProgrammingProblemsCleanUp(), new UnnecessaryCodeCleanUp(), new StringCleanUp(), new SortMembersCleanUp(), new ImportsCleanUp(), new CodeFormatCleanUp(), new CommentFormatCleanUp()};
    }

    public static ICleanUp[] createCleanUps(Map settings) {
        return new ICleanUp[]{new CodeStyleCleanUp(settings), new ControlStatementsCleanUp(settings), new ConvertLoopCleanUp(settings), new VariableDeclarationCleanUp(settings), new ExpressionsCleanUp(settings), new UnusedCodeCleanUp(settings), new Java50CleanUp(settings), new PotentialProgrammingProblemsCleanUp(settings), new UnnecessaryCodeCleanUp(settings), new StringCleanUp(settings), new SortMembersCleanUp(settings), new ImportsCleanUp(settings), new CodeFormatCleanUp(settings), new CommentFormatCleanUp(settings)};
    }

    private static class CleanUpASTRequestor
    extends ASTRequestor {
        private final List fUndoneElements;
        private final Hashtable fSolutions;
        private final Hashtable fCompilationUnitCleanUpMap;
        private final CleanUpRefactoringProgressMonitor fMonitor;

        public CleanUpASTRequestor(List parseList, Hashtable solutions, CleanUpRefactoringProgressMonitor monitor) {
            this.fSolutions = solutions;
            this.fMonitor = monitor;
            this.fUndoneElements = new ArrayList();
            this.fCompilationUnitCleanUpMap = new Hashtable(parseList.size());
            Iterator iter = parseList.iterator();
            while (iter.hasNext()) {
                ParseListElement element = (ParseListElement)iter.next();
                this.fCompilationUnitCleanUpMap.put(element.getCompilationUnit(), element.getCleanUps());
            }
        }

        public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
            this.fMonitor.subTask(this.fMonitor.getSubTaskMessage(source));
            ICompilationUnit primary = (ICompilationUnit)source.getPrimaryElement();
            ICleanUp[] cleanUps = (ICleanUp[])this.fCompilationUnitCleanUpMap.get(primary);
            ICleanUp[] rejectedCleanUps = this.calculateSolutions(source, ast, cleanUps);
            if (rejectedCleanUps.length > 0) {
                this.fUndoneElements.add(new ParseListElement(primary, rejectedCleanUps));
                this.fMonitor.reset();
            } else {
                this.fMonitor.flush();
            }
        }

        public void acceptSource(ICompilationUnit source) {
            this.acceptAST(source, null);
        }

        public List getUndoneElements() {
            return this.fUndoneElements;
        }

        private ICleanUp[] calculateSolutions(ICompilationUnit source, CompilationUnit ast, ICleanUp[] cleanUps) {
            CleanUpChange solution;
            ArrayList result = new ArrayList();
            try {
                solution = CleanUpRefactoring.calculateChange(ast, source, cleanUps, result);
            }
            catch (CoreException e) {
                throw new FixCalculationException(e);
            }
            if (solution != null) {
                try {
                    this.integrateSolution(solution, source);
                }
                catch (JavaModelException e) {
                    throw new FixCalculationException((CoreException)((Object)e));
                }
            }
            return result.toArray(new ICleanUp[result.size()]);
        }

        private void integrateSolution(CleanUpChange solution, ICompilationUnit source) throws JavaModelException {
            ICompilationUnit primary = source.getPrimary();
            ArrayList<CleanUpChange> changes = (ArrayList<CleanUpChange>)this.fSolutions.get(primary);
            if (changes == null) {
                changes = new ArrayList<CleanUpChange>();
                this.fSolutions.put(primary, changes);
            }
            changes.add(solution);
        }
    }

    public static class CleanUpChange
    extends CompilationUnitChange {
        private UndoEdit fUndoEdit;

        public CleanUpChange(String name, ICompilationUnit cunit) {
            super(name, cunit);
        }

        protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
            this.fUndoEdit = edit;
            return super.createUndoChange(edit, stampToRestore);
        }

        public UndoEdit getUndoEdit() {
            return this.fUndoEdit;
        }
    }

    private class CleanUpFixpointIterator {
        private List fParseList;
        private final Hashtable fSolutions;
        private final Hashtable fWorkingCopies;
        private final IJavaProject fProject;
        private final Map fCleanUpOptions;
        private final int fSize;
        private int fIndex;

        public CleanUpFixpointIterator(IJavaProject project, ICompilationUnit[] units, ICleanUp[] cleanUps) {
            this.fProject = project;
            this.fSolutions = new Hashtable(units.length);
            this.fWorkingCopies = new Hashtable();
            this.fParseList = new ArrayList(units.length);
            int i = 0;
            while (i < units.length) {
                this.fParseList.add(new ParseListElement(units[i], cleanUps));
                ++i;
            }
            this.fCleanUpOptions = new Hashtable();
            i = 0;
            while (i < cleanUps.length) {
                ICleanUp cleanUp = cleanUps[i];
                Map currentCleanUpOption = cleanUp.getRequiredOptions();
                if (currentCleanUpOption != null) {
                    this.fCleanUpOptions.putAll(currentCleanUpOption);
                }
                ++i;
            }
            this.fSize = units.length;
            this.fIndex = 1;
        }

        public boolean hasNext() {
            return !this.fParseList.isEmpty();
        }

        public void next(IProgressMonitor monitor) throws CoreException {
            ArrayList<ICompilationUnit> parseList = new ArrayList<ICompilationUnit>();
            ArrayList<ICompilationUnit> sourceList = new ArrayList<ICompilationUnit>();
            Iterator iter = this.fParseList.iterator();
            while (iter.hasNext()) {
                ParseListElement element = (ParseListElement)iter.next();
                ICompilationUnit compilationUnit = element.getCompilationUnit();
                if (this.fSolutions.containsKey(compilationUnit)) {
                    if (this.fWorkingCopies.containsKey(compilationUnit)) {
                        compilationUnit = (ICompilationUnit)this.fWorkingCopies.get(compilationUnit);
                    } else {
                        compilationUnit = compilationUnit.getWorkingCopy(new WorkingCopyOwner(this){
                            final /* synthetic */ CleanUpFixpointIterator this$1;
                            {
                                this.this$1 = cleanUpFixpointIterator;
                            }
                        }, null);
                        this.fWorkingCopies.put(compilationUnit.getPrimary(), compilationUnit);
                    }
                    this.applyChange(compilationUnit, (List)this.fSolutions.get(compilationUnit.getPrimary()));
                }
                if (this.requiresAST(compilationUnit, element.getCleanUps())) {
                    parseList.add(compilationUnit);
                    continue;
                }
                sourceList.add(compilationUnit);
            }
            CleanUpRefactoringProgressMonitor cuMonitor = new CleanUpRefactoringProgressMonitor(monitor, parseList.size() + sourceList.size(), this.fSize, this.fIndex);
            CleanUpASTRequestor requestor = new CleanUpASTRequestor(this.fParseList, this.fSolutions, cuMonitor);
            CleanUpParser parser = new CleanUpParser(this){
                final /* synthetic */ CleanUpFixpointIterator this$1;
                {
                    this.this$1 = cleanUpFixpointIterator;
                }

                protected ASTParser createParser() {
                    ASTParser result = ASTParser.newParser((int)3);
                    result.setResolveBindings(true);
                    result.setProject(CleanUpFixpointIterator.access$0(this.this$1));
                    Map options = RefactoringASTParser.getCompilerOptions((IJavaElement)CleanUpFixpointIterator.access$0(this.this$1));
                    options.putAll(CleanUpFixpointIterator.access$1(this.this$1));
                    result.setCompilerOptions(options);
                    return result;
                }
            };
            try {
                ICompilationUnit[] units = parseList.toArray(new ICompilationUnit[parseList.size()]);
                parser.createASTs(units, new String[0], requestor, (IProgressMonitor)cuMonitor);
            }
            catch (FixCalculationException e) {
                throw e.getException();
            }
            Iterator iterator = sourceList.iterator();
            while (iterator.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iterator.next();
                requestor.acceptSource(cu);
            }
            this.fParseList = requestor.getUndoneElements();
            this.fIndex = cuMonitor.getIndex();
        }

        public void dispose() {
            Iterator iterator = this.fWorkingCopies.values().iterator();
            while (iterator.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iterator.next();
                try {
                    cu.discardWorkingCopy();
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
        }

        private boolean requiresAST(ICompilationUnit compilationUnit, ICleanUp[] cleanUps) throws CoreException {
            int i = 0;
            while (i < cleanUps.length) {
                if (cleanUps[i].requireAST(compilationUnit)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Change[] getResult() {
            Change[] result = new Change[this.fSolutions.size()];
            int i = 0;
            Iterator iterator = this.fSolutions.entrySet().iterator();
            while (iterator.hasNext()) {
                int saveMode;
                Map.Entry entry = iterator.next();
                List changes = (List)entry.getValue();
                ICompilationUnit unit = (ICompilationUnit)entry.getKey();
                try {
                    saveMode = CleanUpRefactoring.this.fLeaveFilesDirty || unit.getBuffer().hasUnsavedChanges() ? 4 : 2;
                }
                catch (JavaModelException e) {
                    saveMode = 4;
                    JavaPlugin.log(e);
                }
                if (changes.size() == 1) {
                    CleanUpChange change = (CleanUpChange)((Object)changes.get(0));
                    change.setSaveMode(saveMode);
                    result[i] = change;
                } else {
                    MultiStateCompilationUnitChange mscuc = new MultiStateCompilationUnitChange(CleanUpRefactoring.getChangeName(unit), unit);
                    int j = 0;
                    while (j < changes.size()) {
                        mscuc.addChange(this.createGroupFreeChange((CleanUpChange)((Object)changes.get(j))));
                        ++j;
                    }
                    mscuc.setSaveMode(saveMode);
                    result[i] = mscuc;
                }
                ++i;
            }
            return result;
        }

        private TextChange createGroupFreeChange(CleanUpChange change) {
            CleanUpChange result = new CleanUpChange(change.getName(), change.getCompilationUnit());
            result.setEdit(change.getEdit());
            result.setSaveMode(change.getSaveMode());
            return result;
        }

        private void applyChange(ICompilationUnit compilationUnit, List changes) throws JavaModelException, CoreException {
            if (changes.size() == 1) {
                CleanUpChange change = (CleanUpChange)((Object)changes.get(changes.size() - 1));
                compilationUnit.getBuffer().setContents(change.getPreviewContent(null));
            } else {
                MultiStateCompilationUnitChange mscuc = new MultiStateCompilationUnitChange("", compilationUnit.getPrimary());
                int i = 0;
                while (i < changes.size()) {
                    mscuc.addChange((TextChange)((CleanUpChange)((Object)changes.get(i))));
                    ++i;
                }
                compilationUnit.getBuffer().setContents(mscuc.getPreviewContent(null));
            }
        }

        static /* synthetic */ IJavaProject access$0(CleanUpFixpointIterator cleanUpFixpointIterator) {
            return cleanUpFixpointIterator.fProject;
        }

        static /* synthetic */ Map access$1(CleanUpFixpointIterator cleanUpFixpointIterator) {
            return cleanUpFixpointIterator.fCleanUpOptions;
        }
    }

    private static abstract class CleanUpParser {
        private static final int MAX_AT_ONCE;

        static {
            long maxMemory = Runtime.getRuntime().maxMemory();
            int ratio = (int)Math.round((double)maxMemory / 6.7108864E7);
            switch (ratio) {
                case 0: {
                    MAX_AT_ONCE = 25;
                    break;
                }
                case 1: {
                    MAX_AT_ONCE = 100;
                    break;
                }
                case 2: {
                    MAX_AT_ONCE = 200;
                    break;
                }
                case 3: {
                    MAX_AT_ONCE = 300;
                    break;
                }
                case 4: {
                    MAX_AT_ONCE = 400;
                    break;
                }
                default: {
                    MAX_AT_ONCE = 500;
                }
            }
        }

        private CleanUpParser() {
        }

        public void createASTs(ICompilationUnit[] units, String[] bindingKeys, CleanUpASTRequestor requestor, IProgressMonitor monitor) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask("", units.length);
                List<ICompilationUnit> list = Arrays.asList(units);
                int end = 0;
                int cursor = 0;
                while (cursor < units.length) {
                    end = Math.min(end + MAX_AT_ONCE, units.length);
                    List<ICompilationUnit> toParse = list.subList(cursor, end);
                    this.createParser().createASTs(toParse.toArray(new ICompilationUnit[toParse.size()]), bindingKeys, (ASTRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(monitor, toParse.size()));
                    cursor = end;
                }
            }
            finally {
                monitor.done();
            }
        }

        protected abstract ASTParser createParser();
    }

    private final class CleanUpRefactoringProgressMonitor
    extends SubProgressMonitor {
        private double fRealWork;
        private int fFlushCount = 0;
        private final int fSize;
        private final int fIndex;

        private CleanUpRefactoringProgressMonitor(IProgressMonitor monitor, int ticks, int size, int index) {
            super(monitor, ticks);
            this.fSize = size;
            this.fIndex = index;
        }

        public void internalWorked(double work) {
            this.fRealWork += work;
        }

        public void flush() {
            super.internalWorked(this.fRealWork);
            this.reset();
            ++this.fFlushCount;
        }

        public void reset() {
            this.fRealWork = 0.0;
        }

        public void done() {
        }

        public int getIndex() {
            return this.fIndex + this.fFlushCount;
        }

        public String getSubTaskMessage(ICompilationUnit source) {
            String typeName = source.getElementName();
            return Messages.format(FixMessages.CleanUpRefactoring_ProcessingCompilationUnit_message, new Object[]{new Integer(this.getIndex()), new Integer(this.fSize), typeName});
        }
    }

    private static class FixCalculationException
    extends RuntimeException {
        private static final long serialVersionUID = 3807273310144726165L;
        private final CoreException fException;

        public FixCalculationException(CoreException exception) {
            this.fException = exception;
        }

        public CoreException getException() {
            return this.fException;
        }
    }

    private static class ParseListElement {
        private final ICompilationUnit fUnit;
        private final ICleanUp[] fCleanUpsArray;

        public ParseListElement(ICompilationUnit unit) {
            this.fUnit = unit;
            this.fCleanUpsArray = new ICleanUp[0];
        }

        public ParseListElement(ICompilationUnit unit, ICleanUp[] cleanUps) {
            this.fUnit = unit;
            this.fCleanUpsArray = cleanUps;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fUnit;
        }

        public ICleanUp[] getCleanUps() {
            return this.fCleanUpsArray;
        }
    }
}

