/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.util;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import uk.ac.kent.cs.kmf.util.ILog;
import uk.ac.kent.cs.kmf.util.Loader;
import uk.ac.kent.cs.kmf.util.Naming;
import uk.ac.kent.cs.kmf.util.Pair;
import uk.ac.kent.cs.kmf.util.PairImpl;
import uk.ac.kent.cs.kmf.util.UMLAdapterFactory;
import uk.ac.kent.cs.kmf.xmi.AdapterFactory;
import uk.ac.kent.cs.kmf.xmi.AdapterFactoryRegister;
import uk.ac.kent.cs.kmf.xmi.IXMIFile;
import uk.ac.kent.cs.kmf.xmi.XMIFile;
import uk.ac.kent.cs.kmf.xmi.XMIReader;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Association;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.AssociationEnd;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Attribute;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Class_;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Classifier;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.EnumLiteral;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Enumeration_;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Feature;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.GeneralizableElement;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Generalization;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Method;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.ModelElement;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Namespace;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Core.Operation;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Foundation.Extension_Mechanisms.Stereotype;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Model_Management.Model;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.Model_Management.Package;
import uk.ac.ukc.cs.kmf.kmfstudio.uml.repository.UmlRepository;

public class XMIToUMLLoader
implements Loader {
    protected static UmlRepository rep;
    protected static Map globalClsToEnum;

    static {
        globalClsToEnum = new HashMap();
    }

    public Pair loadXMI(String inputFile, ILog log) {
        XMIFile xmiFile = null;
        rep = new UmlRepository.Class(log);
        try {
            UMLAdapterFactory adapterFactory = new UMLAdapterFactory(rep, log);
            AdapterFactoryRegister.registerAdapterFactory((AdapterFactory)adapterFactory);
            log.reportMessage("Reading XMI file '" + inputFile + "' ...");
            xmiFile = new XMIReader().read(inputFile, log);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        PairImpl result = new PairImpl(xmiFile, rep);
        return result;
    }

    public Pair loadXMI(File inputFile, ILog log) {
        XMIFile xmiFile = null;
        rep = new UmlRepository.Class(log);
        try {
            UMLAdapterFactory adapterFactory = new UMLAdapterFactory(rep, log);
            AdapterFactoryRegister.registerAdapterFactory((AdapterFactory)adapterFactory);
            log.reportMessage("Reading XMI file '" + inputFile + "' ...");
            xmiFile = new XMIReader().read(inputFile, log);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        PairImpl result = new PairImpl(xmiFile, rep);
        return result;
    }

    public Pair loadXMI(InputStream inputFile, ILog log) {
        XMIFile xmiFile = null;
        rep = new UmlRepository.Class(log);
        try {
            UMLAdapterFactory adapterFactory = new UMLAdapterFactory(rep, log);
            AdapterFactoryRegister.registerAdapterFactory((AdapterFactory)adapterFactory);
            log.reportMessage("Reading XMI file ...");
            xmiFile = new XMIReader().read(inputFile, log);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        PairImpl result = new PairImpl(xmiFile, rep);
        return result;
    }

    public Pair loadModel(String inputFile, ILog log) {
        Pair pair = this.loadXMI(inputFile, log);
        IXMIFile xmiFile = (IXMIFile)pair.getFirst();
        if (xmiFile == null) {
            return null;
        }
        Iterator i = xmiFile.getTopObjects().iterator();
        while (i.hasNext()) {
            Object elem = i.next();
            if (!(elem instanceof Model)) continue;
            XMIToUMLLoader.setMissingLinks((Namespace)elem);
            XMIToUMLLoader.setLinksToEnums((Namespace)elem);
            pair.setFirst(elem);
            return pair;
        }
        pair.setFirst(null);
        return pair;
    }

    public Pair loadModel(File inputFile, ILog log) {
        Pair pair = this.loadXMI(inputFile, log);
        IXMIFile xmiFile = (IXMIFile)pair.getFirst();
        if (xmiFile == null) {
            return null;
        }
        Iterator i = xmiFile.getTopObjects().iterator();
        while (i.hasNext()) {
            Object elem = i.next();
            if (!(elem instanceof Model)) continue;
            XMIToUMLLoader.setMissingLinks((Namespace)elem);
            XMIToUMLLoader.setLinksToEnums((Namespace)elem);
            pair.setFirst(elem);
            return pair;
        }
        pair.setFirst(null);
        return pair;
    }

    public Pair loadModel(InputStream inputFile, ILog log) {
        Pair pair = this.loadXMI(inputFile, log);
        IXMIFile xmiFile = (IXMIFile)pair.getFirst();
        if (xmiFile == null) {
            return null;
        }
        Iterator i = xmiFile.getTopObjects().iterator();
        while (i.hasNext()) {
            Object elem = i.next();
            if (!(elem instanceof Model)) continue;
            XMIToUMLLoader.setMissingLinks((Namespace)elem);
            XMIToUMLLoader.setLinksToEnums((Namespace)elem);
            pair.setFirst(elem);
            return pair;
        }
        pair.setFirst(null);
        return pair;
    }

    protected static void setLinksToEnums(Namespace pkg) {
        Iterator i = pkg.getOwnedElement().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Class_) {
                Class_ cls = (Class_)o;
                cls.setNamespace_(pkg);
                Iterator j = cls.getFeature().iterator();
                while (j.hasNext()) {
                    Classifier type;
                    Enumeration_ enumeration_;
                    Object obj = j.next();
                    if (!(obj instanceof Attribute) || (enumeration_ = (Enumeration_)globalClsToEnum.get(type = ((Attribute)obj).getType())) == null) continue;
                    ((Attribute)obj).setType((Classifier)enumeration_);
                }
                continue;
            }
            if (!(o instanceof Package)) continue;
            ((Package)o).setNamespace_(pkg);
            XMIToUMLLoader.setLinksToEnums((Namespace)((Package)o));
        }
    }

    protected static void setMissingLinks(Namespace pkg) {
        Iterator<Object> i = pkg.getOwnedElement().iterator();
        HashMap<Class_, Enumeration_> clsToEnum = new HashMap<Class_, Enumeration_>();
        while (i.hasNext()) {
            Object obj;
            Iterator j;
            Object o = i.next();
            if (o instanceof GeneralizableElement) {
                GeneralizableElement g = (GeneralizableElement)o;
                j = g.getGeneralization().iterator();
                while (j.hasNext()) {
                    Object o1 = j.next();
                    if (!(o1 instanceof Generalization)) continue;
                    Generalization g1 = (Generalization)o1;
                    GeneralizableElement parent = g1.getParent();
                    parent.getSpecialization().add(g1);
                }
            }
            if (o instanceof Class_) {
                Attribute att;
                Object obj2;
                Class_ cls = (Class_)o;
                cls.setNamespace_(pkg);
                j = cls.getFeature().iterator();
                while (j.hasNext()) {
                    Method method;
                    Operation oper;
                    obj = j.next();
                    ((Feature)obj).setOwner((Classifier)((Class_)o));
                    if (!(obj instanceof Method) || (oper = (method = (Method)obj).getSpecification()) == null) continue;
                    oper.getMethod().add(method);
                }
                if (!Naming.isStereotype((ModelElement)cls, "enumeration")) continue;
                Enumeration_ enumeration_ = (Enumeration_)rep.buildElement("uml.Foundation.Core.Enumeration_");
                enumeration_.setName(cls.getName());
                enumeration_.setNamespace_(cls.getNamespace_());
                List fs = cls.getFeature();
                Vector clone = new Vector();
                clone.addAll(fs);
                int k = 0;
                while (k < clone.size()) {
                    obj2 = clone.get(k);
                    if (obj2 instanceof Attribute) {
                        att = (Attribute)obj2;
                        EnumLiteral lit = (EnumLiteral)rep.buildElement("uml.Foundation.Core.EnumLiteral");
                        lit.setName(att.getName());
                        lit.setNamespace_(att.getNamespace_());
                        lit.setVisibility(att.getVisibility());
                        lit.setEnumeration(enumeration_);
                        enumeration_.getLiterals().add(lit);
                    }
                    ++k;
                }
                int l = 0;
                while (l < clone.size()) {
                    obj2 = clone.get(l);
                    if (obj2 instanceof Attribute) {
                        att = (Attribute)obj2;
                        att.delete();
                        rep.removeElement("uml.Foundation.Core.Attribute", att);
                    }
                    ++l;
                }
                clsToEnum.put(cls, enumeration_);
                continue;
            }
            if (o instanceof Stereotype) {
                Stereotype s = (Stereotype)o;
                Iterator ie = s.getExtendedElement().iterator();
                while (ie.hasNext()) {
                    obj = ie.next();
                    if (!(obj instanceof ModelElement)) continue;
                    ModelElement e = (ModelElement)obj;
                    e.getStereotype().add(s);
                }
                continue;
            }
            if (o instanceof Association) {
                List ends = ((Association)o).getConnection();
                AssociationEnd aend1 = (AssociationEnd)ends.get(0);
                AssociationEnd aend2 = (AssociationEnd)ends.get(1);
                aend1.setAssociation((Association)o);
                aend2.setAssociation((Association)o);
                if (aend1.getType() == null && aend1.getParticipant() != null) {
                    aend1.setType(aend1.getParticipant());
                }
                if (aend2.getType() != null || aend2.getParticipant() == null) continue;
                aend2.setType(aend2.getParticipant());
                continue;
            }
            if (!(o instanceof Package)) continue;
            ((Package)o).setNamespace_(pkg);
            XMIToUMLLoader.setMissingLinks((Namespace)((Package)o));
        }
        i = clsToEnum.keySet().iterator();
        while (i.hasNext()) {
            Object cls = i.next();
            pkg.getOwnedElement().remove(cls);
            pkg.getOwnedElement().add(clsToEnum.get(cls));
        }
        globalClsToEnum.putAll(clsToEnum);
    }
}

