/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.util;

import javax.swing.JTextArea;
import uk.ac.kent.cs.kmf.util.ILog;

public class ConsoleLog
extends JTextArea
implements ILog {
    protected int warNo = 0;
    protected int errNo = 0;
    protected int warUpperBound = 800;
    protected int errUpperBound = 800;

    public void reset() {
        this.setText("");
        this.warNo = 0;
        this.errNo = 0;
    }

    public void resetViolations() {
        this.warNo = 0;
        this.errNo = 0;
    }

    public void resetWarnings() {
        this.warNo = 0;
    }

    public void resetErrors() {
        this.errNo = 0;
    }

    public boolean tooManyViolations() {
        return this.errNo > this.errUpperBound || this.warNo > this.warUpperBound;
    }

    public boolean hasViolations() {
        return this.errNo != 0 || this.warNo != 0;
    }

    public boolean hasErrors() {
        return this.errNo != 0;
    }

    public boolean hasWarnings() {
        return this.warNo != 0;
    }

    public int getWarnings() {
        return this.warNo;
    }

    public int getErrors() {
        return this.errNo;
    }

    public void reportMessage(String message) {
        this.append(String.valueOf(message) + "\n");
    }

    public void printMessage(String message) {
        this.append(message);
    }

    public void reportWarning(String message) {
        ++this.warNo;
        if (this.warNo <= this.warUpperBound) {
            this.append("Warning: " + message + "\n");
        }
    }

    public void reportWarning(String message, Exception e) {
        ++this.warNo;
        if (this.warNo <= this.warUpperBound) {
            this.append("Warning: " + message);
            if (e != null) {
                this.append(e.toString());
            }
            this.append("\n");
        }
    }

    public void reportError(String message) {
        ++this.errNo;
        if (this.errNo <= this.errUpperBound) {
            this.append("Error: " + message + "\n");
        }
    }

    public void reportError(String message, Exception e) {
        ++this.errNo;
        if (this.errNo <= this.errUpperBound) {
            this.append("Error: " + message);
            if (e != null) {
                this.append(e.toString());
            }
            this.append("\n");
        }
    }

    public void finalReport() {
        if (this.errNo <= this.errUpperBound && this.warNo <= this.warUpperBound) {
            this.append("Finished - " + this.errNo + " error(s) " + this.warNo + " warning(s)" + "\n");
        } else {
            if (this.errNo > this.errUpperBound) {
                this.append("Finished - Too many errors.\n");
            }
            if (this.warNo > this.warUpperBound) {
                this.append("Finished - Too many warnings.\n");
            }
        }
    }

    public void setWarUpperBound(int bound) {
        this.warUpperBound = bound;
    }

    public void setErrUpperBound(int bound) {
        this.errUpperBound = bound;
    }

    public void close() {
    }
}

