/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.kent.cs.kmf.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class MatrixPanel
extends JPanel {
    protected GridBagConstraints constraints;
    protected int line;
    protected int column;
    protected EmptyBorder itemBorder;
    protected int fieldSize;
    protected Dimension listSize;
    protected Dimension buttonSize;

    public MatrixPanel() {
        super(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.constraints = new GridBagConstraints();
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.ipadx = 5;
        this.constraints.ipady = 5;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.line = 0;
        this.column = 0;
        this.itemBorder = new EmptyBorder(new Insets(0, 0, 0, 10));
        this.buttonSize = new Dimension(80, 25);
        this.listSize = new Dimension(300, 100);
        this.fieldSize = 25;
    }

    public Component add(Component c, int line, int column) {
        this.constraints.gridx = column;
        this.constraints.gridy = line;
        this.constraints.anchor = 17;
        this.add(c, this.constraints);
        return c;
    }

    public Component add(Component c, int line, int column, int anchor) {
        this.constraints.gridx = column;
        this.constraints.gridy = line;
        this.constraints.anchor = anchor;
        this.add(c, this.constraints);
        return c;
    }

    public JLabel addLabel(String tag, int line, int column) {
        JLabel label = new JLabel(tag);
        label.setBorder(this.itemBorder);
        this.add((Component)label, line, column);
        return label;
    }

    public JTextField addTextField(String initialContent, int line, int column) {
        JTextField field = new JTextField(this.fieldSize);
        field.setText(initialContent);
        this.add((Component)field, line, column);
        return field;
    }

    public JList addList(Vector objects, int line, int column) {
        JList list = new JList(objects);
        JScrollPane c = new JScrollPane(list, 22, 32);
        c.setPreferredSize(this.listSize);
        this.add((Component)c, line, column);
        return list;
    }

    public JList addList(Vector objects, Dimension dim, int line, int column) {
        JList list = new JList(objects);
        JScrollPane c = new JScrollPane(list, 22, 32);
        c.setPreferredSize(dim);
        this.add((Component)c, line, column);
        return list;
    }

    public JButton addButton(String label, int line, int column) {
        JButton button = new JButton(label);
        button.setPreferredSize(this.buttonSize);
        this.add((Component)button, line, column);
        return button;
    }

    public Dimension getButtonSize() {
        return this.buttonSize;
    }

    public void setButtonSize(Dimension dimension) {
        this.buttonSize = dimension;
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public void setFieldSize(int i) {
        this.fieldSize = i;
    }

    public Dimension getListSize() {
        return this.listSize;
    }

    public void setListSize(Dimension i) {
        this.listSize = i;
    }

    public EmptyBorder getItemBorder() {
        return this.itemBorder;
    }

    public void setItemBorder(EmptyBorder border) {
        this.itemBorder = border;
    }

    public GridBagConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(GridBagConstraints constraints) {
        this.constraints = constraints;
    }
}

